define(['FitnessCongratsService', 'FitnessCongratsConstants'], function() {
    'use strict';

    describe("The Fitness Congratulatory Message Service", function (){
        var service, constants, message, messageType, dashboard,
            localStorageKey = 'fitheart-congrats-dashboard';

        beforeEach(function() {
            module('angularTemplateApp');
            localStorage.removeItem(localStorageKey);
            inject(function(FitnessCongratsService, FitnessCongratsConstants) {
                service = FitnessCongratsService;
                constants = FitnessCongratsConstants;
            });
        });

        describe("when instantiated", function() {
            it("service should be defined correctly", function() {
                expect(service.getGoalReachedMessage).toBeDefined();
                expect(service.getStandardMessage).toBeDefined();
                expect(service.fetchLocalStorage).toBeDefined();
            });
        });

        describe("methods", function() {
            it("should iterate sequentially over every item before randomizing Goal Reached messages", function() {
                messageType = 'goal-reached';
                                    
                for(var i=0; i<100; i++) {
                    dashboard = service.fetchLocalStorage();
                    message = service.getGoalReachedMessage();

                    if(i < Number(constants[messageType].title.length)) {
                        expect(i).toEqual(dashboard[messageType].title);
                        expect(message.title).toEqual(constants[messageType].title[i]);
                    } else {
                        expect(message.title).toBeDefined();
                    }
                    
                    if(i < Number(constants[messageType].text.length)) {
                        expect(i).toEqual(dashboard[messageType].text);
                        expect(message.text).toEqual(constants[messageType].text[i]);
                    } else {
                        expect(message.text).toBeDefined();
                    }
                }    
            });
        });

        describe("methods", function() {
            it("should iterate sequentially over every item before randomizing Standard messages", function() {
                messageType = 'standard';

                for(var i=0; i<100; i++) {
                    dashboard = service.fetchLocalStorage();
                    message = service.getStandardMessage();

                    if(i < Number(constants[messageType].title.length)) {
                        expect(i).toEqual(dashboard[messageType].title);
                        expect(message.title).toEqual(constants[messageType].title[i]);
                    } else {
                        expect(message.title).toBeDefined();                        
                    }
                    
                    if(i < Number(constants[messageType].text.length)) {
                        expect(i).toEqual(dashboard[messageType].text);
                        expect(message.text).toEqual(constants[messageType].text[i]);
                    } else {
                        expect(message.text).toBeDefined();
                    }
                }
            });
        });
    });
});